<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
     <title>Le changement commence ici - Transformation du scoutisme burundais</title>
     <meta name="description" content="Découvrez le changement qui transformera le scoutisme burundais. Restez informé(e) en laissant votre numéro WhatsApp." />
   <meta name="theme-color" content="#6A0DAD" />

  <!-- Bootstrap 5 & Icons (CDN) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet" />

  <!-- Font -->
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet" />

  <style>
     :root {
       --brand-primary: #602596;
       --brand-secondary: #0093b4;
       --brand-accent: #fe5656;
       --brand-dark: #4e006f;
       --brand-light: #f8fafc;
       --brand-cream: #f6f5ef;
       /* Compatibility */
       --brand-teal: #20B2AA;
       --brand-red: #fe5656;
       --brand-purple: #602596;
     }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: "Inter", system-ui, -apple-system, sans-serif;
       background: linear-gradient(135deg, rgba(96, 37, 150, 0.95) 0%, rgba(0, 147, 180, 0.85) 100%),
                   url('/assets/hero1.jpg') center/cover no-repeat fixed;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #fff;
      padding: 2rem;
    }

    .coming-soon-container {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(10px);
      border-radius: 2rem;
      padding: 3rem 2.5rem;
      max-width: 600px;
      width: 100%;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
      text-align: center;
      color: #1a1a1a;
    }

    .icon-wrapper {
      width: 100px;
      height: 100px;
      margin: 0 auto 2rem;
      background: linear-gradient(135deg, var(--brand-purple), var(--brand-secondary));
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow: 0 10px 30px rgba(32, 178, 170, 0.3);
      animation: pulse 2s ease-in-out infinite;
    }

    @keyframes pulse {
      0%, 100% {
        transform: scale(1);
        box-shadow: 0 10px 30px rgba(0, 147, 180, 0.3);
      }
      50% {
        transform: scale(1.05);
        box-shadow: 0 15px 40px rgba(0, 147, 180, 0.4);
      }
    }

    .icon-wrapper i {
      font-size: 3rem;
      color: #fff;
    }

    h1 {
      font-size: 2.5rem;
      font-weight: 800;
       color: var(--brand-secondary);
       margin-bottom: 1rem;
       letter-spacing: -0.5px;
       text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
     }

    .subtitle {
      font-size: 1.2rem;
      color: #4c4c4c;
      margin-bottom: 2.5rem;
      line-height: 1.7;
    }

     .subtitle strong {
       color: var(--brand-red);
       font-weight: 700;
     }

    .form-group {
      margin-bottom: 1.5rem;
      text-align: left;
    }

     .form-label {
       font-weight: 600;
       color: var(--brand-purple);
       margin-bottom: 0.5rem;
       display: block;
     }

    .form-control {
      padding: 0.875rem 1.25rem;
      border: 2px solid #e0e0e0;
      border-radius: 0.75rem;
      font-size: 1rem;
      transition: all 0.3s ease;
      width: 100%;
    }

     .form-control:focus {
       outline: none;
       border-color: var(--brand-secondary);
       box-shadow: 0 0 0 3px rgba(0, 147, 180, 0.2);
     }

    .whatsapp-input-group {
      display: flex;
      align-items: center;
      gap: 0.5rem;
      background: #f8f9fa;
      padding: 0.5rem;
      border-radius: 0.75rem;
      border: 2px solid #e0e0e0;
    }

     .whatsapp-input-group:focus-within {
       border-color: var(--brand-secondary);
       box-shadow: 0 0 0 3px rgba(0, 147, 180, 0.2);
     }

    .whatsapp-icon {
      color: #25D366;
      font-size: 1.5rem;
      margin-left: 0.5rem;
    }

    .whatsapp-input-group .form-control {
      border: none;
      background: transparent;
      padding: 0.875rem 0.5rem;
      flex: 1;
    }

    .whatsapp-input-group .form-control:focus {
      box-shadow: none;
    }

     .btn-submit {
       background: linear-gradient(135deg, var(--brand-secondary), var(--brand-purple));
       color: #fff;
       border: none;
       padding: 1rem 2.5rem;
       border-radius: 0.75rem;
       font-size: 1.1rem;
       font-weight: 600;
       cursor: pointer;
       transition: all 0.3s ease;
       width: 100%;
       box-shadow: 0 8px 20px rgba(0, 147, 180, 0.3);
     }

     .btn-submit:hover {
       transform: translateY(-2px);
       box-shadow: 0 12px 30px rgba(0, 147, 180, 0.4);
       color: #fff;
     }

    .btn-submit:active {
      transform: translateY(0);
    }

    .success-message {
      display: none;
      background: #d4edda;
      color: #155724;
      padding: 1rem;
      border-radius: 0.75rem;
      margin-top: 1.5rem;
      border: 1px solid #c3e6cb;
    }

    .success-message.show {
      display: block;
    }

    .error-message {
      display: none;
      background: #f8d7da;
      color: #721c24;
      padding: 1rem;
      border-radius: 0.75rem;
      margin-top: 1.5rem;
      border: 1px solid #f5c6cb;
    }

    .error-message.show {
      display: block;
    }

    .invalid-feedback {
      display: block;
      color: #dc3545;
      font-size: 0.875rem;
      margin-top: 0.5rem;
    }

    .was-validated .form-control:invalid {
      border-color: #dc3545;
    }

    .was-validated .whatsapp-input-group:has(.form-control:invalid) {
      border-color: #dc3545;
    }

    @media (max-width: 576px) {
      .coming-soon-container {
        padding: 2rem 1.5rem;
      }

      h1 {
        font-size: 2rem;
      }

      .subtitle {
        font-size: 1rem;
      }

      .icon-wrapper {
        width: 80px;
        height: 80px;
        margin-bottom: 1.5rem;
      }

      .icon-wrapper i {
        font-size: 2.5rem;
      }
    }
  </style>
</head>
<body>
  <div class="coming-soon-container">
          <div class="icon-wrapper">
        <i class="bi bi-arrow-up-right-circle"></i>
      </div>
    
    <h1>Le changement commence ici</h1>
    <p class="subtitle">
      Une Association des Scouts unie, dynamique et crédible. Une jeunesse formée, engagée et fière de ses valeurs.<br />
      <strong>Soyez les premiers à découvrir</strong> cette nouvelle vision qui transformera le scoutisme burundais.
    </p>

    <form id="whatsappForm" novalidate>
      <div class="form-group">
                 <label for="whatsapp" class="form-label">
           <i class="bi bi-whatsapp me-2" style="color: #25D366;"></i>
           Restez connecté(e) pour vivre le changement en direct
         </label>
        <div class="whatsapp-input-group">
          <i class="bi bi-whatsapp whatsapp-icon"></i>
          <input 
            type="tel" 
            id="whatsapp" 
            name="whatsapp" 
            class="form-control" 
            placeholder="+257 79 00 00 00" 
            required 
            pattern="^\+?[1-9]\d{1,14}$"
          />
        </div>
                                   <div class="invalid-feedback">
            Veuillez entrer un numéro WhatsApp valide pour être informé(e) des changements (ex: +257 79 00 00 00)
          </div>
      </div>

      <button type="submit" class="btn-submit">
        <i class="bi bi-arrow-right-circle-fill me-2"></i>
        Je veux faire partie du changement
      </button>
    </form>

    <div class="success-message" id="successMessage">
      <i class="bi bi-check-circle-fill me-2"></i>
      <span>Merci ! Vous serez informé(e) en priorité de cette transformation qui va changer l'avenir du scoutisme.</span>
    </div>

    <div class="error-message" id="errorMessage">
      <i class="bi bi-exclamation-triangle-fill me-2"></i>
      Une erreur s'est produite. Veuillez réessayer.
    </div>
  </div>

  <!-- JS Bootstrap -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  
  <script>
    const form = document.getElementById('whatsappForm');
    const successMessage = document.getElementById('successMessage');
    const errorMessage = document.getElementById('errorMessage');

    form.addEventListener('submit', function(event) {
      event.preventDefault();
      event.stopPropagation();

      // Reset messages
      successMessage.classList.remove('show');
      errorMessage.classList.remove('show');

      if (!form.checkValidity()) {
        form.classList.add('was-validated');
        return;
      }

      const formData = new FormData(form);
      const whatsappNumber = formData.get('whatsapp');

      // Sauvegarder le numéro côté serveur
      fetch('save-whatsapp.php', {
        method: 'POST',
        body: formData
      })
      .then(response => response.json())
      .then(data => {
        if (data.success) {
          // Mettre à jour le message de succès si un message personnalisé est fourni
          if (data.message) {
            const span = successMessage.querySelector('span');
            if (span) {
              span.textContent = data.message;
            } else {
              successMessage.innerHTML = '<i class="bi bi-check-circle-fill me-2"></i>' + data.message;
            }
          }
          successMessage.classList.add('show');
          form.reset();
          form.classList.remove('was-validated');
          
          // Scroll vers le message de succès
          setTimeout(() => {
            successMessage.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
          }, 100);
        } else {
          errorMessage.textContent = data.message || 'Une erreur s\'est produite. Veuillez réessayer.';
          errorMessage.classList.add('show');
        }
      })
      .catch(error => {
        console.error('Erreur:', error);
        errorMessage.textContent = 'Une erreur de connexion s\'est produite. Veuillez réessayer.';
        errorMessage.classList.add('show');
      });
    });

    // Formatage automatique du numéro (optionnel)
    const whatsappInput = document.getElementById('whatsapp');
    whatsappInput.addEventListener('input', function(e) {
      let value = e.target.value.replace(/[^0-9+]/g, '');
      // Assurez-vous que le + est au début si présent
      if (value.startsWith('+')) {
        e.target.value = '+' + value.slice(1).replace(/[^0-9]/g, '');
      } else {
        e.target.value = value;
      }
    });
  </script>
</body>
</html>
